/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.settings.network;

import com.ibm.hwmca.fw.settings.network.NetworkSettingsChangedEvent;
import com.ibm.hwmca.fw.settings.network.NetworkSettingsChangedEventListener;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NetworkSettingsChangedManager {
    private static final String TRACE_MASKD = "XSETNSCT";
    private static final String TRACE_MASKF = "XSETNSCF";
    private static final String TRACE_MASKT = "XSETNSCD";
    private static NetworkSettingsChangedManager instance;
    private List listeners;
    private Object listenersLock;

    private NetworkSettingsChangedManager() {
        Trace.trace(TRACE_MASKT, "<> NetworkSettingsChangedManager constructor()");
        this.listenersLock = new Object();
        this.listeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkSettingsChangedEventListener(NetworkSettingsChangedEventListener listener) {
        Trace.trace(TRACE_MASKT, "NetworkSettingsChangedManager.addNetworkSettingsChangedEventListener()");
        if (listener == null) {
            throw new IllegalArgumentException("NetworkSettingsChangedEventListener may not be null");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.add(listener);
            Trace.trace(TRACE_MASKT, "Adding a listener. Now have " + this.listeners.size() + " listeners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkSettingsChangedEventListener(NetworkSettingsChangedEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("NetworkSettingsChangedEventListener may not be null");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    public void notify(NetworkSettingsChangedEvent event) {
        Trace.trace(TRACE_MASKT, "-> NetworkSettingsChangedManager.notify");
        this.notifyNetworkSettingsChangedEventListeners(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNetworkSettingsChangedEventListeners(NetworkSettingsChangedEvent event) {
        Trace.trace(TRACE_MASKT, "-> NetworkSettingsChangedManager.notifyNetworkSettingsChangedEventListeners");
        Object object = this.listenersLock;
        synchronized (object) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                NetworkSettingsChangedEventListener listener = (NetworkSettingsChangedEventListener)iterator.next();
                listener.networkSettingsChanged(event);
            }
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettingsChangedManager.notifyNetworkSettingsChangedEventListeners");
    }

    public static synchronized NetworkSettingsChangedManager getNetworkSettingsChangedManager() {
        if (instance == null) {
            Trace.trace(TRACE_MASKT, "NetworkSettingsChangedManager: Creating new NetworkSettingsChangedManager");
            instance = new NetworkSettingsChangedManager();
        } else {
            Trace.trace(TRACE_MASKT, "NetworkSettingsChangedManager: Using old NetworkSettingsChangedManager");
        }
        return instance;
    }
}

